/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.ui.internal.wizards;

import com.aptana.core.CoreStrings;
import com.aptana.core.util.FileUtil;
import com.aptana.core.util.StringUtil;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.github.IGithubManager;
import com.aptana.git.ui.internal.preferences.GithubAccountPageProvider;
import com.aptana.git.ui.internal.wizards.Messages;
import com.aptana.git.ui.internal.wizards.RepositorySelectionPage;
import java.io.File;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class GithubRepositorySelectionPage
extends WizardPage {
    private String destination;
    private GithubAccountPageProvider userInfoProvider;
    private Control userInfoControl;
    private Text destinationText;
    private Text ownerText;
    private Text repoText;
    private String owner;
    private String repoName;

    protected GithubRepositorySelectionPage() {
        super(RepositorySelectionPage.class.getName());
        this.setTitle(Messages.RepositorySelectionPage_Title);
        this.setDescription(Messages.RepositorySelectionPage_Description);
    }

    public void createControl(Composite parent) {
        Composite main = new Composite(parent, 0);
        main.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).create());
        main.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        GridDataFactory inputData = GridDataFactory.swtDefaults().hint(300, -1);
        this.userInfoProvider = new GithubAccountPageProvider();
        this.userInfoControl = this.userInfoProvider.createContents(main);
        this.userInfoControl.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
        Label ownerLabel = new Label(main, 0);
        ownerLabel.setText(Messages.GithubRepositorySelectionPage_OwnerLabel);
        this.ownerText = new Text(main, 2052);
        this.ownerText.setLayoutData((Object)inputData.create());
        this.ownerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GithubRepositorySelectionPage.this.owner = GithubRepositorySelectionPage.this.ownerText.getText();
                GithubRepositorySelectionPage.this.validate();
            }
        });
        new Label(main, 0);
        Label repoLabel = new Label(main, 0);
        repoLabel.setText(Messages.GithubRepositorySelectionPage_RepoNameLabel);
        this.repoText = new Text(main, 2052);
        this.repoText.setLayoutData((Object)inputData.create());
        this.repoText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GithubRepositorySelectionPage.this.repoName = GithubRepositorySelectionPage.this.repoText.getText();
                GithubRepositorySelectionPage.this.validate();
            }
        });
        new Label(main, 0);
        Label dest = new Label(main, 0);
        dest.setText(Messages.RepositorySelectionPage_Destination_Label);
        this.destinationText = new Text(main, 2052);
        this.destinationText.setLayoutData((Object)inputData.create());
        this.destinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GithubRepositorySelectionPage.this.validate();
            }
        });
        Button destinationButton = new Button(main, 8);
        destinationButton.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        destinationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String r;
                FileDialog d = new FileDialog(GithubRepositorySelectionPage.this.getShell(), 73728);
                String text = GithubRepositorySelectionPage.this.destinationText.getText();
                if (!StringUtil.isEmpty((String)text)) {
                    File file = new File(text).getAbsoluteFile();
                    d.setFilterPath(file.getParent());
                    d.setFileName(file.getName());
                }
                if ((r = d.open()) != null) {
                    GithubRepositorySelectionPage.this.destinationText.setText(r);
                }
            }
        });
        this.setErrorMessage(null);
        this.setControl((Control)main);
    }

    protected void updateURI() {
        if (this.owner != null && this.repoName != null) {
            String workspacePath = this.generateDestinationPath();
            this.destinationText.setText(workspacePath);
        }
        this.validate();
    }

    private void validate() {
        if (StringUtil.isEmpty((String)this.owner)) {
            this.setErrorMessage(Messages.GithubRepositorySelectionPage_NoOwnerErr);
            this.setPageComplete(false);
            return;
        }
        if (StringUtil.isEmpty((String)this.repoName)) {
            this.setErrorMessage(Messages.GithubRepositorySelectionPage_NoRepoNameErr);
            this.setPageComplete(false);
            return;
        }
        String dstpath = this.destinationText.getText();
        if (StringUtil.isEmpty((String)dstpath)) {
            this.setErrorMessage(Messages.RepositorySelectionPage_DestinatioNRequired_Message);
            this.setPageComplete(false);
            return;
        }
        File absoluteFile = new File(dstpath).getAbsoluteFile();
        if (!FileUtil.isEmptyDir((File)absoluteFile)) {
            this.setErrorMessage(NLS.bind((String)Messages.RepositorySelectionPage_DirectoryExists_ErrorMessage, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        if (!FileUtil.canCreateSubdir((File)absoluteFile.getParentFile())) {
            this.setErrorMessage(NLS.bind((String)Messages.RepositorySelectionPage_CannotCreateDirectory_ErrorMessage, (Object)absoluteFile.getPath()));
            this.setPageComplete(false);
            return;
        }
        this.destination = dstpath;
        try {
            this.getGithubManager().getRepo(this.owner, this.repoName);
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            this.setPageComplete(false);
        }
    }

    private IGithubManager getGithubManager() {
        return GitPlugin.getDefault().getGithubManager();
    }

    public String getDestination() {
        return this.destination;
    }

    protected String generateDestinationPath() {
        int slash;
        String workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
        String uri = String.valueOf(this.owner) + '/' + this.repoName;
        int index = uri.lastIndexOf(".git");
        if (index == -1) {
            index = uri.length();
        }
        if ((slash = uri.lastIndexOf(47, index)) != -1) {
            workspacePath = String.valueOf(workspacePath) + File.separator + uri.substring(slash + 1, index);
        }
        return workspacePath;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getRepoName() {
        return this.repoName;
    }
}

